/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "mx_auto_config.h"
#include "myriexpress.h"
#if !MX_OS_WINNT
#include <unistd.h>
#else
#include "mx_uni.h"
#endif
#include "test_common.h"   

#define MAX_LEN   131072

int main(void)
{
  mx_endpoint_t ep;
  mx_endpoint_addr_t addr;
  char send_buff1[80], send_buff2[MAX_LEN];
  char recv_buff1[80], recv_buff2[MAX_LEN];
  mx_segment_t send_seg;
  mx_segment_t recv_seg;
  mx_request_t send_req;
  mx_request_t recv_req;
  mx_status_t status; 
  mx_return_t ret;
  uint32_t result;

  mx_init();
  mx_set_error_handler(MX_ERRORS_RETURN);
  /*
  ret = mx_iprobe(ep, 0, 10, MX_MATCH_MASK_NONE, &status, &result);
  insist(ret == MX_BAD_ENDPOINT); 
  */
  ret = mx_open_endpoint(MX_ANY_NIC, MX_ANY_ENDPOINT, 0, NULL, 0, &ep);
  insist(ret == MX_SUCCESS);
  ret = mx_get_endpoint_addr(ep, &addr);
  insist(ret == MX_SUCCESS);

  send_seg.segment_ptr = send_buff1;
  send_seg.segment_length = 80;
  recv_seg.segment_ptr = recv_buff1;
  recv_seg.segment_length = 80;
   
  /* check unexpected eager msg */

  ret = mx_iprobe(ep, 10, MX_MATCH_MASK_NONE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 0));
  send_buff1[0] = 'a';
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req);
  mx_wait(ep, &send_req, 1000, &status, &result);
  sleep(1);
  ret = mx_iprobe(ep, 10, MX_MATCH_MASK_NONE, &status, &result);
  insist ((ret == MX_SUCCESS) && (result == 1));
  insist (status.msg_length == 80);
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  insist(ret == MX_SUCCESS);

  /* check unexpected truncated eager msg -- posted recv shorter than send */

  recv_seg.segment_length = 20;
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req);
  sleep(1);
  mx_wait(ep, &send_req, 1000, &status, &result);
  ret = mx_iprobe(ep, 10, MX_MATCH_MASK_NONE, &status, &result);
  insist ((ret == MX_SUCCESS) && (result == 1));
  insist (status.code == MX_STATUS_SUCCESS);
  insist (status.msg_length == 80);
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  insist(ret == MX_SUCCESS);

  /* check unexpected partial eager msg -- posted recv longer than send */

  recv_seg.segment_length = 80;
  send_seg.segment_length = 10;
  ret = mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req);
  mx_wait(ep, &send_req, 1000, &status, &result);
  sleep(1);
  ret = mx_iprobe(ep, 10, MX_MATCH_MASK_NONE, &status, &result);
  insist ((ret == MX_SUCCESS) && (result == 1));
  insist (status.code == MX_STATUS_SUCCESS);
  insist (status.msg_length == 10);
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);

  /* check unexpected rndv msg */

  send_seg.segment_ptr = send_buff2;
  send_seg.segment_length = MAX_LEN;
  recv_seg.segment_ptr = recv_buff2;
  recv_seg.segment_length = MAX_LEN;
  
  fill_data(send_buff2, MAX_LEN);
  mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req);
  ret = mx_wait(ep, &send_req, 1000, &status, &result);
  printf ("mx_wait returns %d for rndv isend, status.code = %d, msg_len = %d, xfer_len = %d\n", 
	  ret, status.code, status.msg_length, status.xfer_length);
  fflush(stdout);
  insist((ret == MX_SUCCESS) && (result == 0));  /* time out */
  sleep(1);
  ret = mx_iprobe(ep, 10, MX_MATCH_MASK_NONE, &status, &result);
  insist ((ret == MX_SUCCESS) && (result == 1));
  printf ("iprobe unexpected rndv msg returns status with msg_len = %d\n", 
	  status.msg_length);
  fflush(stdout);
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  ret = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(status.code == MX_STATUS_SUCCESS);
  insist(status.msg_length == MAX_LEN);
  insist(status.xfer_length == MAX_LEN);
  check_data(recv_buff2, MAX_LEN);

  ret = mx_wait(ep, &send_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(status.code == MX_STATUS_SUCCESS);
  insist(status.msg_length == MAX_LEN);
  /* insist(status.xfer_length == -1); */

  /* check unexpected truncated rndv msg */

  send_seg.segment_length = MAX_LEN;
  recv_seg.segment_length = MAX_LEN / 2;
  
  fill_data(send_buff2 + 1, MAX_LEN);
  mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req);
  ret = mx_wait(ep, &send_req, 1000, &status, &result);
  printf ("mx_wait returns %d for rndv isend, status.code = %d, msg_len = %d, xfer_len = %d\n", 
	  ret, status.code, status.msg_length, status.xfer_length);
  fflush(stdout);
  insist((ret == MX_SUCCESS) && (result == 0));
  sleep(1);
  ret = mx_iprobe(ep, 10, MX_MATCH_MASK_NONE, &status, &result);
  insist ((ret == MX_SUCCESS) && (result == 1));
  printf ("iprobe unexpected rndv msg returns status with msg_len = %d\n", 
	  status.msg_length);
  fflush(stdout);
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  ret = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(status.code == MX_STATUS_TRUNCATED);
  insist(status.msg_length == MAX_LEN);
  /* insist(status.xfer_length == MAX_LEN); */
  printf ("mx_wait unexpected rndv irecv msg returns status with msg_len = %d and xfer_len = %d\n", 
	  status.msg_length, status.xfer_length);
  fflush(stdout);
  check_data(recv_buff2 + 1, MAX_LEN / 2 - 1);

  ret = mx_wait(ep, &send_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(status.msg_length == MAX_LEN);
  /* insist(status.xfer_length == -1); */

  /* check unexpected partial rndv msg */
  
  send_seg.segment_length = MAX_LEN / 2;
  recv_seg.segment_length = MAX_LEN;
 
  fill_data(send_buff2, MAX_LEN / 2);
  mx_isend(ep, &send_seg, 1, addr, 10, NULL, &send_req);
  ret = mx_wait(ep, &send_req, 1000, &status, &result);
  printf ("mx_wait returns %d for rndv isend, status.code = %d, msg_len = %d, xfer_len = %d\n", 
	  ret, status.code, status.msg_length, status.xfer_length);
  fflush(stdout);
  insist((ret == MX_SUCCESS) && (result == 0));   /* time out */
  sleep(1);
  ret = mx_iprobe(ep, 10, MX_MATCH_MASK_NONE, &status, &result);
  insist ((ret == MX_SUCCESS) && (result == 1));
  printf ("iprobe unexpected rndv msg returns status with msg_len = %d\n", 
	  status.msg_length);
  fflush(stdout);
  ret = mx_irecv(ep, &recv_seg, 1, 10, MX_MATCH_MASK_NONE, NULL, &recv_req);
  ret = mx_wait(ep, &recv_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(status.code == MX_STATUS_SUCCESS);
  insist(status.msg_length == MAX_LEN / 2);
  insist(status.xfer_length == MAX_LEN / 2);
  check_data(recv_buff2, MAX_LEN);

  ret = mx_wait(ep, &send_req, MX_INFINITE, &status, &result);
  insist((ret == MX_SUCCESS) && (result == 1));
  insist(status.code == MX_STATUS_SUCCESS);
  insist(status.msg_length == MAX_LEN / 2);
  /* insist(status.xfer_length == -1); */

  mx_close_endpoint(ep);
  mx_finalize();
  return 0;
}
